VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmMagnetometerControl 
   Caption         =   "Magnetometer Control"
   ClientHeight    =   3060
   ClientLeft      =   10650
   ClientTop       =   4620
   ClientWidth     =   4185
   Icon            =   "frmMagnetometerControl.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3060
   ScaleWidth      =   4185
   Visible         =   0   'False
   Begin VB.Frame frameControl 
      BorderStyle     =   0  'None
      Caption         =   "Automatic Data Collection"
      Height          =   975
      Index           =   0
      Left            =   240
      TabIndex        =   0
      Top             =   480
      Width           =   3612
      Begin VB.CommandButton cmdChangerEdit 
         Caption         =   "&Modify"
         Enabled         =   0   'False
         Height          =   315
         Left            =   240
         TabIndex        =   1
         Top             =   600
         Width           =   735
      End
      Begin VB.CommandButton cmdChangerOK 
         Caption         =   "Start changer"
         Enabled         =   0   'False
         Height          =   315
         Left            =   1440
         TabIndex        =   2
         Top             =   600
         Width           =   1212
      End
   End
   Begin VB.Frame frameControl 
      BorderStyle     =   0  'None
      Caption         =   "Manual Data Collection"
      Height          =   1935
      Index           =   1
      Left            =   240
      TabIndex        =   3
      Top             =   480
      Width           =   3612
      Begin VB.ComboBox cmbManSample 
         Height          =   315
         Left            =   2160
         TabIndex        =   4
         Top             =   120
         Width           =   1332
      End
      Begin VB.TextBox txtSampleHeight 
         Height          =   285
         Left            =   2160
         TabIndex        =   5
         Top             =   600
         Width           =   1335
      End
      Begin VB.CommandButton cmdManHolder 
         Caption         =   "Measure &Holder"
         Enabled         =   0   'False
         Height          =   315
         Left            =   360
         TabIndex        =   6
         Top             =   1080
         Width           =   1332
      End
      Begin VB.CommandButton cmdManRun 
         Caption         =   "&Measure Sample"
         Enabled         =   0   'False
         Height          =   315
         Left            =   2040
         TabIndex        =   7
         Top             =   1080
         Width           =   1452
      End
      Begin VB.CheckBox chkVacuum 
         Caption         =   "Keep the vacuum on"
         Height          =   315
         Left            =   0
         TabIndex        =   8
         Top             =   1680
         Width           =   1935
      End
      Begin VB.CommandButton cmdOpenSampleFile 
         Caption         =   "Open Sample File"
         Enabled         =   0   'False
         Height          =   315
         Left            =   2040
         TabIndex        =   9
         Top             =   1560
         Width           =   1452
      End
      Begin VB.Label lblManSample 
         Caption         =   "Choose Sample:"
         Height          =   255
         Left            =   360
         TabIndex        =   10
         Top             =   120
         Width           =   1305
      End
      Begin VB.Label Label1 
         Caption         =   "Sample Height (cm):"
         Height          =   255
         Left            =   360
         TabIndex        =   11
         Top             =   600
         Width           =   1455
      End
   End
   Begin ComctlLib.TabStrip tbsControl 
      Height          =   2415
      Left            =   120
      TabIndex        =   12
      Top             =   120
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   4260
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   2
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Automatic Data Collection"
            Key             =   "tabAutomatic"
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Manual Data Collection"
            Key             =   "tabManual"
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin VB.ComboBox cmbSusceptibilityScaleFactor 
      Height          =   315
      Left            =   3240
      TabIndex        =   13
      Text            =   "Combo1"
      Top             =   2640
      Width           =   855
   End
   Begin VB.Label Label19 
      Caption         =   "Susceptibility scale:"
      Height          =   375
      Left            =   1680
      TabIndex        =   14
      Top             =   2640
      Width           =   1575
   End
End
Attribute VB_Name = "frmMagnetometerControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private SampleCode As String
Private DataFileDrv As String
Private DataFileDir As String
Private datafilename As String
Private fileReadyToLoad As Boolean
Private initialized As Boolean

Private Sub form_show()
    Me.Left = val(Config_GetSetting("Program", "MagnetometerControlWindowLeft", "0"))
    Me.Top = val(Config_GetSetting("Program", "MagnetometerControlWindowTop", "0"))
End Sub

Private Sub chkVacuum_Click()
    If cmdManHolder.Enabled = True Then
      If frmVacuum.VacuumConnectOn = True And chkVacuum = Unchecked Then
        MsgBox "Will switch off the vacuum."
        frmVacuum.ValveConnect False
        frmVacuum.MotorPower False
      End If
    End If
End Sub

Private Sub cmbSusceptibilityScaleFactor_Click()
    SusceptibilityScaleFactor = val(cmbSusceptibilityScaleFactor)
    Config_SaveSetting "SusceptibilityCalibration", "SusceptibilityScaleFactor", Str$(SusceptibilityScaleFactor)
    frmSusceptibilityMeter.LagTime
End Sub

Private Sub cmdOpenSampleFile_Click()
    Dim filename As String
    Dim specName As String, specParent As String
    Dim specimen As Sample
    If LenB(cmbManSample.Text) = 0 Then Exit Sub
    specName = cmbManSample.Text
    specParent = SampleIndexRegistry.SampleFileByIndex(cmbManSample.ListIndex + 1)
    If SampleIndexRegistry.IsValidSample(specParent, specName) Then
        Set specimen = SampleIndexRegistry(specParent).sampleSet(specName)
        filename = specimen.SpecFilePath
        Set specimen = Nothing
    End If
    DataAnalysis_SampleFile (filename)
End Sub

Private Sub Form_Load()
    Dim i As Integer
    If FileExists(Prog_IcoFile) And LenB(Prog_IcoFile) > 0 Then frmMagnetometerControl.Icon = LoadPicture(Prog_IcoFile) ' (October 2007 L Carporzen)
    ' Initialize private variables
    initialized = False
    HolderMeasured = False
    ' Fill normal combo boxes
    cmbSusceptibilityScaleFactor.Clear
    cmbSusceptibilityScaleFactor.AddItem "1.0"
    cmbSusceptibilityScaleFactor.AddItem "0.1"
    cmbSusceptibilityScaleFactor = Format$(SusceptibilityScaleFactor, "0.0")
    cmdOpenSampleFile.Enabled = False
    selectTab (1)
End Sub

Private Sub form_resize()
    ' Dont let the user resize this...
    If Me.WindowState = vbNormal Then
        Me.Height = 3465
        Me.Width = 4305
    End If
End Sub

Private Sub cmbManSample_click()
    cmbManSample_Change
End Sub

Private Sub cmbManSample_Change()
    Dim specName As String, specParent As String
    Dim specimen As Sample
    If LenB(cmbManSample.Text) = 0 Then Exit Sub
    EnableMagnetCmds
    specName = cmbManSample.Text
    specParent = SampleIndexRegistry.SampleFileByIndex(cmbManSample.ListIndex + 1)
    If SampleIndexRegistry.IsValidSample(specParent, specName) Then
        cmdOpenSampleFile.Enabled = True
        Set specimen = SampleIndexRegistry(specParent).sampleSet(specName)
        If specimen.SampleHeight > 0 Then
            txtSampleHeight = Format$(specimen.SampleHeight / UpDownMotor1cm, "0.00")
        Else
            txtSampleHeight = Format$(SampleHeight / UpDownMotor1cm, "0.00")
        End If
        Set specimen = Nothing
    Else
        cmdOpenSampleFile.Enabled = False
    End If
End Sub

Private Sub cmdChangerEdit_Click()
    If frmMeasure.buttonHalt.Enabled = False Then
        Flow_Resume ' (September 2007 L Carporzen) Allow to restart a measurement after pressing Halt during the previous
        frmMeasure.updateFlowStatus
    End If
    MainChanger.cmdSeq_Click
End Sub

Private Sub cmdChangerOK_Click()
         cmdChangerEdit.Enabled = False 'cmdChangerEdit.Enabled = True
         FLAG_MagnetUse = True         ' Notify that we're using magnetometer
         DisableMagnetCmds             ' Disable buttons that use magnetometer
         frmProgram.mnuViewMeasurement.Enabled = True ' Update menu bar
         SampQueue.Execute
            'Changer_ProcessSamplesToQueue repHolder
         Changer_NearestHole           ' Always park at nearest hole
         FLAG_MagnetUse = False        ' Notify that we're done!
         EnableMagnetCmds
End Sub

Private Sub cmdManHolder_Click()
    If Not FLAG_MagnetUse Then
        FLAG_MagnetUse = True        ' Notify that we're using magnetometer
        DisableMagnetCmds            ' Disable buttons that use magnetometer
        Changer_NearestHole          ' Move sample changer to nearest hole
        SampleHolder.SampleHeight = val(txtSampleHeight) * UpDownMotor1cm
        frmProgram.StatBarNew "Measuring holder..."
        'DisplayStatus (4)            ' Measuring Holder...
        frmProgram.mnuViewMeasurement.Enabled = True
        frmProgram.mnuViewMeasurement.Checked = True
        Load frmMeasure
        Load frmStats
        frmMeasure.HideStats
        frmMeasure.clearStats
        frmMeasure.clearData
        frmMeasure.SetSample "Holder"
        frmMeasure.MomentX.Visible = False ' (October 2007 L Carporzen) Susceptibility versus demagnetization
        frmMeasure.framJumps.Top = 5040
        frmMeasure.framJumps.Left = 5400
        frmMeasure.InitEqualArea ' (August 2007 L Carporzen) Equal area plot
        frmMeasure.ZOrder
        frmMeasure.Show
        If COMPortSusceptibility > 0 And EnableSusceptibility Then frmSusceptibilityMeter.LagTime
        ' reset SampleHolder step type to NRM, just in case
        SampleHolder.Parent.measurementSteps(1).StepType = "NRM"
        SampleHolder.Parent.measurementSteps(1).level = 0
'        Motor_MoveLoadToZero         ' Lower sample to zero position
        'MotorUpDn_Move ZeroPos, 2
        Measure_TreatAndRead SampleHolder, False ' Read Holder
'        Motor_MoveZeroToLoad         ' Raise sample back to load position
        MotorUpDn_Move 0, 2
        HolderMeasured = True        ' Set the "holder measured" flag
        'DisplayStatus (5)            ' Waiting for motor to stop...
 '       Motor_WaitStop ("UPDOWN")              ' Wait for motor
        'DisplayStatus (-1)           ' Clear status bar
        frmProgram.StatBarNew vbNullString
        FLAG_MagnetUse = False       ' Notify that we stopped
        EnableMagnetCmds
        SampleHolder.SampleHeight = 0
    End If
End Sub

Private Sub cmdManRun_Click()
    Dim ret As VbMsgBoxResult
    Dim specName As String
    Dim specParent As String
    Dim specimen As Sample
    Dim doUpOriginal As Boolean
    If frmMeasure.buttonHalt.Enabled = False Then
        Flow_Resume ' (September 2007 L Carporzen) Allow to restart a measurement after pressing Halt during the previous
        frmMeasure.updateFlowStatus
    End If
    If SampleIndexRegistry.Count = 0 Then
        MsgBox "Please press Add to registry..." ' (September 2007 L Carporzen) Need to have something in the registry
        Exit Sub
    End If
    frmVacuum.MotorPower True
    If Not FLAG_MagnetUse Then
        If Not HolderMeasured Then
            ' We haven't measured the holder yet. Query user.
            ret = MsgBox("The holder has not been measured yet, " & _
                "measure it now?", vbOKCancel, "Continue?")
            If ret = vbOK Then
                cmdManHolder_Click
            Else
                Exit Sub
            End If
        End If
        If Prog_halted Then Exit Sub ' (September 2007 L Carporzen) New version of the Halt button
        FLAG_MagnetUse = True   ' Notify that we're using magnetometer
        DisableMagnetCmds       ' Disable buttons that use magnetometer
        frmProgram.mnuViewMeasurement.Enabled = True   ' Update menu bar
        specName = cmbManSample.Text
        specParent = SampleIndexRegistry.SampleFileByIndex(cmbManSample.ListIndex + 1)
        Set specimen = SampleIndexRegistry(specParent).sampleSet(specName)
        SampleHeight = val(txtSampleHeight) * UpDownMotor1cm
        specimen.SampleHeight = SampleHeight
        Load frmMeasure
        Load frmStats
        frmMeasure.clearData
        frmMeasure.HideStats
        frmMeasure.MomentX.Visible = False ' (October 2007 L Carporzen) Susceptibility & demagnetization versus steps
        frmMeasure.framJumps.Top = 5040
        frmMeasure.framJumps.Left = 5400
        frmMeasure.InitEqualArea ' (August 2007 L Carporzen) Equal area plot
        frmMeasure.ZOrder
        frmMeasure.Show
        With specimen.Parent
            doUpOriginal = .doUp
            frmMeasure.SetFields .avgSteps, .curDemagLong, .doUp, .doBoth, .filename
        End With
        frmMeasure.SetSample cmbManSample.Text
        frmProgram.StatBarNew "Measuring..."
        frmMeasure.ZOrder
        frmMeasure.Show
        ' if we're in rockmag mode and IRM is enabled, discharge the IRM coil
        ' before loading the sample
        If specimen.Parent.RockmagMode And EnableIRM Then frmIRMARM.FireIRM 0
        Measure_QueryLoad frmMeasure.GetSample, frmMeasure.getMeasDir
        frmProgram.mnuViewMeasurement.Checked = True
        With specimen.Parent
            MotorUpDn_Move Int(SCoilPos + AFPos / 2), 1
            Measure_TreatAndRead specimen, False    ' Read data starting from zero pos
            MotorUpDn_Move 0, 2
            If .doUp And .doBoth Then
                specimen.Parent.doUp = False
                Measure_QueryLoad frmMeasure.GetSample, Magnet_SampleOrientationDown
                frmMeasure.ZOrder
                frmMeasure.Show
                frmProgram.mnuViewMeasurement.Checked = True
                MotorUpDn_Move Int(ZeroPos + specimen.SampleHeight / 2), 2
                Measure_TreatAndRead specimen, False   ' Read data starting from zero pos
                MotorUpDn_Move 0, 2
                .doUp = doUpOriginal
            End If
        End With
        If Prog_halted Then ' (September 2007 L Carporzen) New version of the Halt button
            Flow_Resume
            frmMeasure.updateFlowStatus
            Exit Sub
        End If
        If specimen.Parent.measurementSteps.Count > 1 Then
            SetCodeLevel CodeOrange
            frmSendMail.MailNotification "Sample done", "Sample " & specName & " done. Please remove sample.", CodeOrange
        End If
        If chkVacuum.value = Unchecked Then ' (August 2007 L Carporzen) Vacuum could stay after the sample done
        MsgBox "Sample " & specName & " done. Please remove sample."
        Else
        MsgBox "Sample " & specName & " done. The vacuum will stay on."
        End If
        SetCodeLevel CodeBlue, True
        SampleNameCurrent = vbNullString
        If chkVacuum.value = Unchecked Then frmVacuum.ValveConnect False ' (August 2007 L Carporzen) Vacuum could stay
        frmStats.Hide
        frmMeasure.Hide
        FLAG_MagnetUse = False      ' Notify that we're done
        EnableMagnetCmds
    End If
    Set specimen = Nothing
    If chkVacuum.value = Unchecked Then frmVacuum.MotorPower False ' (August 2007 L Carporzen) Vacuum could stay
End Sub

Private Sub Form_Hide()
    'Close all sub forms
    If Me.WindowState <> vbMinimized Then
        Config_SaveSetting "Program", "MagnetometerControlWindowLeft", Str(Me.Left)
        Config_SaveSetting "Program", "MagnetometerControlWindowTop", Str(Me.Top)
    End If
End Sub

Public Sub RefreshManSampleList()
    ' Adds fields to the combobox
    ' cmbManSamp, so the user can manually select samples to view
    ' or measure.
    Dim i As Integer, j As Integer
    cmbManSample.Clear
On Error GoTo fin
    If SampleIndexRegistry.Count = 0 Then Exit Sub
    For i = 1 To SampleIndexRegistry.Count
        With SampleIndexRegistry(i).sampleSet
        If .Count > 0 Then
            For j = 1 To .Count
                cmbManSample.AddItem .Item(j).Samplename
            Next j
        End If
        End With
    Next i
    On Error GoTo 0
fin:
End Sub

Public Sub DisableMagnetCmds()
    ' Disable all commands that use the magnetometer
    'tbsControl.Enabled = False
    cmdChangerEdit.Enabled = False
    cmbSusceptibilityScaleFactor.Enabled = False
    cmdChangerOK.Enabled = False
    cmdManHolder.Enabled = False
    cmdManRun.Enabled = False
End Sub

Public Sub EnableMagnetCmds()
    ' This procedure enables the commands that require use of the
    ' magnetometer once the magnetometer is initialized.  We know when
    ' it is initialized when the flag FLAG_MagnetInit is true.
    If FLAG_MagnetInit And Not FLAG_MagnetUse Then
        'tbsControl.Enabled = True
        cmdChangerEdit.Enabled = True
        'cmdChangerOK.Enabled = True ' (October 2007 L Carporzen) Allow to run later
        cmdManHolder.Enabled = True
        cmbSusceptibilityScaleFactor.Enabled = True
 '       frmsettings.cmdVac.Enabled = True
        EnableMagnetRun
    End If
End Sub

Public Sub EnableMagnetRun()
    ' When the sample selected is changed, and a valid sample is
    ' selected, then enable the cmdManRun button, so we can run the
    ' sample.
    If FLAG_MagnetInit And Not FLAG_MagnetUse _
        And (Not cmdManRun.Enabled) Then
        ' The button is not enabled and we are allowed to enable it
        If cmbManSample.ListIndex <> -1 Then
            ' We have selected a sample in the combo box
            cmdManRun.Enabled = True        ' Enable the Run button
        Else
            ' !! Make a way to just type in the same name
        End If
    End If
End Sub

Private Sub selectTab(tabtoselect As Integer)
    Dim i As Integer
    'show and enable the selected tab's controls
    'and hide and disable all others
    RefreshManSampleList
    For i = 0 To tbsControl.Tabs.Count - 1
        If i = tabtoselect - 1 Then
            frameControl(i).Visible = True
            frameControl(i).Enabled = True
            frameControl(i).ZOrder 0
        Else
            frameControl(i).Visible = False
            frameControl(i).Enabled = False
        End If
    Next
End Sub

Private Sub tbsControl_Click()
    selectTab tbsControl.SelectedItem.Index
End Sub
